﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Net.Mail
Imports System.Text
Imports System.ServiceProcess

Public Class MainForm
    Inherits System.Windows.Forms.Form

    Dim arlAttachments As ArrayList


    ''' <summary>
    ''' 处理“Browse”(浏览)按钮的 Click 事件。使用 OpenFileDialog
    ''' 使用户能够找到要发送的附件，然后将该附件
    ''' 添加到 MailAttachment 对象的数组列表中。 
    ''' </summary>
    Private Sub Browse_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Browse.Click
        With odlgAttachment
            .InitialDirectory = "C:\"
            .Filter = "All Files (*.*)|*.*|HTML Files (*.htm;*.html)|*.htm|Microsoft Mail Documents (*.msg)|*.msg|Word Documents (*.doc)|*.doc|Excel Files(*.xl*)|*.xl*|Excel Worksheets (*.xls)|*.xls|Excel Charts (*.xlc)|*.xlc|PowerPoint Presentations (*.ppt)|*.ppt|Text Files (*.txt)|*.txt"
            .FilterIndex = 1

            ' OpenFileDialog 控件只包含一个“Open”(打开)按钮，而没有“OK”(确定)。
            ' 但是没有 DialogResult.Open 枚举所以使用 DialogResult.OK。
            If .ShowDialog() = Windows.Forms.DialogResult.OK Then
                If IsNothing(arlAttachments) Then
                    arlAttachments = New ArrayList()

                    ' 清除 ListView 中的默认文本“No Attachments”(无附件)
                    Attachments.Items.Clear()
                End If
                arlAttachments.Add(New Attachment(.FileName))

                ' 您只需显示文件名。OpenFileDialog.FileName 属性中包含完整路径。因此拆
                ' 分路径并将其反转以获取数组中的第一个字符串，即 FileName。
                ' 
                Dim strFileName() As String = .FileName.Split(New Char() {CChar("\")})
                System.Array.Reverse(strFileName)
                Attachments.Items.Add(strFileName(0))
            End If
        End With
    End Sub

    ''' <summary>
    ''' 处理“Send”(发送)按钮的 Click 事件。此例程检查正确的电子邮件地址，使用
    '''  StringBuilder 生成邮件正文，创建邮件并尝试发送该邮件。
    ''' 
    ''' </summary>
    Private Sub Send_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Send.Click

        If ToAddress.Text = "" Or From.Text = "" Then
            MsgBox("You must enter both To and From email addresses.")
            Exit Sub
        End If

        ' 使用 StringBuilder 类而不是传统的字符串串联。因为它能够修改基础缓冲区而
        ' 不是必须保留每个串联的副本，所以已针对生成字符串进行了优化。
        ' 
        ' 
        Dim sb As New StringBuilder()

        ' 生成电子邮件正文。
        sb.Append("The following email was sent to you from the Send Mail " & _
            "sample application:")
        sb.Append(vbCrLf)
        sb.Append(vbCrLf)
        sb.Append("SUBJECT: ")
        sb.Append(Trim(Subject.Text))
        sb.Append(vbCrLf)
        sb.Append(vbCrLf)
        sb.Append("MESSAGE: ")
        sb.Append(Trim(Body.Text))
        sb.Append(vbCrLf)

        ' 创建邮件就像实例化类并设置若干个属性一样简单。
        ' 
        Dim mailMsg As New MailMessage(From.Text.Trim, ToAddress.Text.Trim)
        With mailMsg
            If Not String.IsNullOrEmpty(CC.Text) Then
                .CC.Add(New MailAddress(CC.Text.Trim))
            End If

            If Not String.IsNullOrEmpty(BCC.Text) Then
                .Bcc.Add(New MailAddress(BCC.Text.Trim))
            End If

            .Subject = Subject.Text.Trim
            .Body = sb.ToString

            If Not IsNothing(arlAttachments) Then
                Dim mailAttachment As Attachment
                For Each mailAttachment In arlAttachments
                    .Attachments.Add(mailAttachment)
                Next
            End If
        End With

        ' 设置 SmtpServer 名称。通常可以是以下值(具体要根据您的本地安全设置):
        ' 

        ' a) 本地 IP 地址(假设您的本地计算机的 SMTP 服务器有权限通过本地防火墙(如果有)
        ' 发送邮件。

        ' b) 127.0.0.1 - 本地计算机的环回。

        ' c) “smarthost”或者您用于收发邮件的 Exchange 服务器的名称或 IP 地址。通常，
        ' 在您处于公司防火墙保护下时需要此值。
        ' 

        ' 使用结构化错误处理来尝试发送电子邮件和向用户提供有关尝试失败还是成功的反馈。 
        ' 
        ' 
        Try
            Dim client As New SmtpClient("smarthost")
            client.Send(mailMsg)
            Attachments.Items.Clear()
            Attachments.Items.Add("(No Attachments)")

            MessageBox.Show("Your email has been successfully sent!", _
                "Email Send Status", MessageBoxButtons.OK, _
                MessageBoxIcon.Information)
        Catch exp As Exception
            MessageBox.Show("The following problem occurred when attempting to " & _
                "send your email: " & exp.Message, _
                Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub

    ''' <summary>
    ''' 处理表单的 Load 事件。检查以确保 SMTP 服务已安装且正在运行。
    ''' 
    ''' </summary>
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load, MyBase.Load, MyBase.Load, MyBase.Load
        ' 确保已安装 SMTP 服务。
        Dim services() As ServiceController = ServiceController.GetServices
        Dim service As ServiceController = Nothing
        Dim blnHasSmtpService As Boolean = False

        ' 遍历计算机上的所有服务并查找 SMTP 服务。
        For Each service In services
            If service.ServiceName.ToLower = "smtpsvc" Then
                blnHasSmtpService = True
                Exit For
            End If
        Next

        If Not blnHasSmtpService Then
            MessageBox.Show("You do not have SMTP Service installed on this " & _
                "machine. Please check the Readme file for information on how " & _
                "to install SMTP Service.", Me.Text, _
                MessageBoxButtons.OK, MessageBoxIcon.Information)
            service.Stop()
        End If

        ' 确保 SMTP 服务正在运行。如果没有运行，则启动该服务。
        If Not service.Status = ServiceControllerStatus.Running Then
            Try
                service.Start()
            Catch
                MsgBox("There was an error when attempting " & _
                    "to start SMTP Service. Please consult the Readme " & _
                    "file for more information.")
            End Try
        End If

        ' 使用 MailPriority 值填充“Priority”(优先级)复选框。
        With Priority
            .Items.AddRange(New String() {"Normal", "Low", "High"})
            .SelectedIndex = 0
        End With
    End Sub

    Private Sub ExitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
